<?php
namespace App\Controllers\Admin;

use App\Core\View;
use App\Core\DB;
use App\Core\Auth;
use App\Core\Helpers;

final class AuthController {
  public function loginForm(): void {
    View::page('admin/auth/login', ['error' => null]);
  }

  public function login(): void {
    Helpers::verifyCsrf();
    $email = trim($_POST['email'] ?? '');
    $password = (string)($_POST['password'] ?? '');
    $u = DB::query("SELECT id,name,email,password_hash,role FROM users WHERE email=? LIMIT 1", [$email]);
    if (!$u || !password_verify($password, $u[0]['password_hash'])) {
      View::page('admin/auth/login', ['error' => 'بيانات الدخول غير صحيحة']);
      return;
    }
    Auth::login(['id'=>$u[0]['id'],'name'=>$u[0]['name'],'email'=>$u[0]['email'],'role'=>$u[0]['role']]);
    Helpers::redirect('/admin/dashboard');
  }

  public function logout(): void {
    Helpers::verifyCsrf();
    Auth::logout();
    Helpers::redirect('/admin');
  }
}
