<?php
namespace App\Controllers\Admin;

use App\Core\View;
use App\Core\Auth;
use App\Core\DB;

final class DashboardController {
  public function index(): void {
    Auth::requireRole('admin');
    $counts = [
      'posts' => (int)(DB::query("SELECT COUNT(*) c FROM posts")[0]['c'] ?? 0),
      'works' => (int)(DB::query("SELECT COUNT(*) c FROM works")[0]['c'] ?? 0),
      'tickets' => (int)(DB::query("SELECT COUNT(*) c FROM contact_tickets")[0]['c'] ?? 0),
    ];
    View::page('admin/dashboard', compact('counts'));
  }
}
