<?php
namespace App\Controllers\Admin;

use App\Core\View;
use App\Core\Auth;
use App\Core\DB;
use App\Core\Helpers;

final class PostsController {
  public function index(): void {
    Auth::requireRole('admin');
    $posts = DB::query("SELECT id,title,slug,views,created_at FROM posts ORDER BY id DESC LIMIT 200");
    View::page('admin/posts/index', compact('posts'));
  }

  public function create(): void {
    Auth::requireRole('admin');
    View::page('admin/posts/create', ['errors'=>[], 'old'=>[]]);
  }

  public function store(): void {
    Auth::requireRole('admin');
    Helpers::verifyCsrf();
    $title = trim($_POST['title'] ?? '');
    $slug = trim($_POST['slug'] ?? '');
    $excerpt = trim($_POST['excerpt'] ?? '');
    $content = trim($_POST['content'] ?? '');

    $errors = [];
    if ($title === '') $errors['title'] = 'العنوان مطلوب';
    if ($slug === '') $errors['slug'] = 'السلاج مطلوب';
    if ($content === '') $errors['content'] = 'المحتوى مطلوب';
    if ($errors) { View::page('admin/posts/create', ['errors'=>$errors,'old'=>$_POST]); return; }

    DB::exec("INSERT INTO posts (title,slug,excerpt,content,views,created_at) VALUES (?,?,?,?,0,NOW())",
      [$title,$slug,$excerpt,$content]);
    Helpers::redirect('/admin/posts');
  }

  public function edit(array $params): void {
    Auth::requireRole('admin');
    $id = (int)($params['id'] ?? 0);
    $post = DB::query("SELECT * FROM posts WHERE id=? LIMIT 1", [$id]);
    if (!$post) { http_response_code(404); echo "Not found"; return; }
    View::page('admin/posts/edit', ['post'=>$post[0],'errors'=>[]]);
  }

  public function update(array $params): void {
    Auth::requireRole('admin');
    Helpers::verifyCsrf();
    $id = (int)($params['id'] ?? 0);
    $title = trim($_POST['title'] ?? '');
    $slug = trim($_POST['slug'] ?? '');
    $excerpt = trim($_POST['excerpt'] ?? '');
    $content = trim($_POST['content'] ?? '');
    DB::exec("UPDATE posts SET title=?,slug=?,excerpt=?,content=? WHERE id=?", [$title,$slug,$excerpt,$content,$id]);
    Helpers::redirect('/admin/posts/'.$id);
  }

  public function delete(array $params): void {
    Auth::requireRole('admin');
    Helpers::verifyCsrf();
    $id = (int)($params['id'] ?? 0);
    DB::exec("DELETE FROM posts WHERE id=?", [$id]);
    Helpers::redirect('/admin/posts');
  }
}
