<?php
namespace App\Controllers\Admin;

use App\Core\View;
use App\Core\Auth;
use App\Core\DB;
use App\Core\Helpers;

final class TicketsController {
  public function index(): void {
    Auth::requireRole('admin');
    $tickets = DB::query("SELECT id,name,email,department,subject,status,created_at FROM contact_tickets ORDER BY id DESC LIMIT 300");
    View::page('admin/tickets/index', compact('tickets'));
  }

  public function show(array $params): void {
    Auth::requireRole('admin');
    $id = (int)($params['id'] ?? 0);
    $ticket = DB::query("SELECT * FROM contact_tickets WHERE id=? LIMIT 1", [$id]);
    if (!$ticket) { http_response_code(404); echo "Not found"; return; }
    $replies = DB::query("SELECT * FROM contact_ticket_replies WHERE ticket_id=? ORDER BY id ASC", [$id]);
    View::page('admin/tickets/show', ['ticket'=>$ticket[0],'replies'=>$replies,'error'=>null]);
  }

  public function reply(array $params): void {
    Auth::requireRole('admin');
    Helpers::verifyCsrf();
    $id = (int)($params['id'] ?? 0);
    $msg = trim($_POST['message'] ?? '');
    if ($msg === '') {
      Helpers::redirect('/admin/tickets/'.$id);
    }
    DB::exec("INSERT INTO contact_ticket_replies (ticket_id,admin_id,message,created_at) VALUES (?,?,?,NOW())",
      [$id, (Auth::user()['id'] ?? null), $msg]);
    DB::exec("UPDATE contact_tickets SET status='in_progress' WHERE id=?", [$id]);
    Helpers::redirect('/admin/tickets/'.$id);
  }
}
