<?php
namespace App\Controllers\Admin;

use App\Core\View;
use App\Core\Auth;
use App\Core\DB;
use App\Core\Helpers;

final class WorksController {
  public function index(): void {
    Auth::requireRole('admin');
    $works = DB::query("SELECT id,title,slug,year,sector,location,category_slug FROM works ORDER BY id DESC LIMIT 200");
    View::page('admin/works/index', compact('works'));
  }

  public function create(): void {
    Auth::requireRole('admin');
    $cats = DB::query("SELECT slug,title FROM work_categories ORDER BY sort_order ASC");
    View::page('admin/works/create', ['cats'=>$cats,'errors'=>[],'old'=>[]]);
  }

  public function store(): void {
    Auth::requireRole('admin');
    Helpers::verifyCsrf();
    $title = trim($_POST['title'] ?? '');
    $slug = trim($_POST['slug'] ?? '');
    $category_slug = trim($_POST['category_slug'] ?? '');
    $year = trim($_POST['year'] ?? '');
    $sector = trim($_POST['sector'] ?? '');
    $location = trim($_POST['location'] ?? '');
    $description = trim($_POST['description'] ?? '');

    $errors = [];
    if ($title === '') $errors['title'] = 'العنوان مطلوب';
    if ($slug === '') $errors['slug'] = 'السلاج مطلوب';
    if ($category_slug === '') $errors['category_slug'] = 'اختر التصنيف';
    if ($errors) {
      $cats = DB::query("SELECT slug,title FROM work_categories ORDER BY sort_order ASC");
      View::page('admin/works/create', ['cats'=>$cats,'errors'=>$errors,'old'=>$_POST]);
      return;
    }

    DB::exec("INSERT INTO works (title,slug,category_slug,year,sector,location,description,created_at)
              VALUES (?,?,?,?,?,?,?,NOW())",
              [$title,$slug,$category_slug,$year,$sector,$location,$description]);
    Helpers::redirect('/admin/works');
  }
}
