<?php
namespace App\Controllers;

use App\Core\View;
use App\Core\DB;
use App\Core\Helpers;

final class BlogController {
  public function index(): void {
    $posts = DB::query("SELECT id,title,slug,excerpt,views,created_at FROM posts ORDER BY created_at DESC LIMIT 50");
    View::page('site/blog/index', compact('posts'));
  }

  public function show(array $params): void {
    $slug = $params['slug'] ?? '';
    $post = DB::query("SELECT * FROM posts WHERE slug=? LIMIT 1", [$slug]);
    if (!$post) { http_response_code(404); echo View::render('errors/404', ['path' => '/blog/'.$slug]); return; }
    $post = $post[0];
    DB::exec("UPDATE posts SET views = views + 1 WHERE id=?", [$post['id']]);
    $similar = DB::query("SELECT id,title,slug FROM posts WHERE id<>? ORDER BY created_at DESC LIMIT 6", [$post['id']]);
    View::page('site/blog/show', compact('post','similar'));
  }
}
