<?php
namespace App\Controllers\Client;

use App\Core\View;
use App\Core\DB;
use App\Core\Helpers;

final class AuthController {
  public function loginForm(): void {
    View::page('client/auth/login', ['error'=>null]);
  }

  public function login(): void {
    Helpers::verifyCsrf();
    $email = trim($_POST['email'] ?? '');
    $password = (string)($_POST['password'] ?? '');
    $u = DB::query("SELECT id,full_name,email,password_hash FROM client_users WHERE email=? LIMIT 1", [$email]);
    if (!$u || !password_verify($password, $u[0]['password_hash'])) {
      View::page('client/auth/login', ['error'=>'بيانات الدخول غير صحيحة']);
      return;
    }
    $_SESSION['client_user'] = ['id'=>$u[0]['id'],'full_name'=>$u[0]['full_name'],'email'=>$u[0]['email']];
    Helpers::redirect('/client/portal');
  }

  public function logout(): void {
    Helpers::verifyCsrf();
    unset($_SESSION['client_user']);
    Helpers::redirect('/client');
  }
}
