<?php
namespace App\Controllers;

use App\Core\View;
use App\Core\DB;
use App\Core\Helpers;

final class ContactController {
  public function form(): void {
    View::page('site/contact/form', ['errors' => [], 'old' => []]);
  }

  public function submit(): void {
    Helpers::verifyCsrf();

    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $whatsapp = trim($_POST['whatsapp'] ?? '');
    $department = trim($_POST['department'] ?? '');
    $subject = trim($_POST['subject'] ?? '');
    $message = trim($_POST['message'] ?? '');
    $captcha = trim($_POST['captcha'] ?? '');

    $errors = [];
    if ($name === '') $errors['name'] = 'الاسم مطلوب';
    if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors['email'] = 'البريد غير صحيح';
    if ($department === '') $errors['department'] = 'اختر القسم';
    if ($subject === '') $errors['subject'] = 'العنوان مطلوب';
    if ($message === '') $errors['message'] = 'التفاصيل مطلوبة';

    if (!hash_equals($_SESSION['captcha_answer'] ?? '', $captcha)) {
      $errors['captcha'] = 'الكابتشا غير صحيحة';
    }

    // attachment (optional)
    $attachmentPath = null;
    if (!empty($_FILES['attachment']['name'])) {
      $tmp = $_FILES['attachment']['tmp_name'];
      if (is_uploaded_file($tmp)) {
        $dir = BASE_PATH . '/storage/uploads/tickets';
        if (!is_dir($dir)) mkdir($dir, 0775, true);
        $safeName = time() . '_' . preg_replace('/[^a-zA-Z0-9._-]/', '_', $_FILES['attachment']['name']);
        $dest = $dir . '/' . $safeName;
        move_uploaded_file($tmp, $dest);
        $attachmentPath = 'storage/uploads/tickets/' . $safeName;
      }
    }

    if ($errors) {
      View::page('site/contact/form', ['errors' => $errors, 'old' => $_POST]);
      return;
    }

    DB::exec("INSERT INTO contact_tickets (name,email,whatsapp,department,subject,message,attachment_path,status,created_at)
              VALUES (?,?,?,?,?,?,?,?,NOW())",
              [$name,$email,$whatsapp,$department,$subject,$message,$attachmentPath,'new']);

    $_SESSION['flash'] = 'تم إرسال رسالتك بنجاح، وسيتم الرد عليك قريبًا.';
    Helpers::redirect('/contact');
  }
}
