<?php
namespace App\Controllers;

use App\Core\View;
use App\Core\DB;

final class HomeController {
  public function index(): void {
    $services = [];
    $works = [];
    $posts = [];
    if (file_exists(BASE_PATH . '/config/database.php')) {
      try {
        $services = DB::query("SELECT id,title,excerpt FROM services ORDER BY sort_order ASC LIMIT 6");
        $works = DB::query("SELECT id,title,slug,year,sector,location FROM works ORDER BY id DESC LIMIT 8");
        $posts = DB::query("SELECT id,title,slug,views FROM posts ORDER BY id DESC LIMIT 6");
      } catch (\Throwable $e) {
        // ignore pre-install
      }
    }
    View::page('site/home', compact('services','works','posts'));
  }
}
