<?php
namespace App\Controllers;

use App\Core\View;
use App\Core\DB;

final class WorksController {
  public function index(): void {
    $category = $_GET['cat'] ?? 'all';
    if ($category === 'all') {
      $works = DB::query("SELECT id,title,slug,year,sector,location FROM works ORDER BY id DESC LIMIT 100");
    } else {
      $works = DB::query("SELECT id,title,slug,year,sector,location FROM works WHERE category_slug=? ORDER BY id DESC LIMIT 100", [$category]);
    }
    $cats = DB::query("SELECT slug,title FROM work_categories ORDER BY sort_order ASC");
    View::page('site/works/index', compact('works','cats','category'));
  }

  public function show(array $params): void {
    $slug = $params['slug'] ?? '';
    $work = DB::query("SELECT * FROM works WHERE slug=? LIMIT 1", [$slug]);
    if (!$work) { http_response_code(404); echo View::render('errors/404', ['path' => '/works/'.$slug]); return; }
    $work = $work[0];
    $similar = DB::query("SELECT id,title,slug FROM works WHERE id<>? AND category_slug=? ORDER BY id DESC LIMIT 6", [$work['id'], $work['category_slug']]);
    View::page('site/works/show', compact('work','similar'));
  }
}
