<?php
namespace App\Core;

final class Auth {
  public static function user(): ?array {
    return $_SESSION['user'] ?? null;
  }

  public static function check(): bool {
    return (bool)self::user();
  }

  public static function login(array $user): void {
    $_SESSION['user'] = $user;
  }

  public static function logout(): void {
    unset($_SESSION['user']);
  }

  public static function requireRole(string $role): void {
    $u = self::user();
    if (!$u || ($u['role'] ?? '') !== $role) {
      http_response_code(403);
      echo "Forbidden";
      exit;
    }
  }
}
