<?php
namespace App\Core;

final class Config {
  private static array $data = [];

  public static function load(string $configDir): void {
    foreach (glob($configDir . '/*.php') as $file) {
      $key = basename($file, '.php');
      self::$data[$key] = require $file;
    }
  }

  public static function get(string $key, mixed $default = null): mixed {
    $parts = explode('.', $key);
    $value = self::$data;
    foreach ($parts as $p) {
      if (!is_array($value) || !array_key_exists($p, $value)) return $default;
      $value = $value[$p];
    }
    return $value;
  }
}
