<?php
namespace App\Core;

final class Helpers {
  public static function e(string $s): string {
    return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
  }

  public static function redirect(string $path): void {
    header('Location: ' . $path);
    exit;
  }

  public static function url(string $path): string {
    $base = rtrim(Config::get('app.base_url', ''), '/');
    return $base . $path;
  }

  public static function csrfToken(): string {
    if (empty($_SESSION['_csrf'])) {
      $_SESSION['_csrf'] = bin2hex(random_bytes(16));
    }
    return $_SESSION['_csrf'];
  }

  public static function verifyCsrf(): void {
    $token = $_POST['_csrf'] ?? '';
    if (!$token || !hash_equals($_SESSION['_csrf'] ?? '', $token)) {
      http_response_code(419);
      echo "CSRF token mismatch.";
      exit;
    }
  }
}
