<?php
namespace App\Core;

final class View {
  public static function render(string $view, array $data = []): string {
    $file = BASE_PATH . '/resources/views/' . $view . '.php';
    if (!file_exists($file)) {
      return "View not found: " . Helpers::e($view);
    }
    extract($data, EXTR_SKIP);
    ob_start();
    require $file;
    return (string)ob_get_clean();
  }

  public static function page(string $view, array $data = []): void {
    echo self::render($view, $data);
  }
}
