<?php
declare(strict_types=1);

session_start();

define('BASE_PATH', dirname(__DIR__));

require BASE_PATH . '/vendor/autoload.php';

use App\Core\Config;
use App\Core\DB;

Config::load(BASE_PATH . '/config');

// Initialize DB (if installed)
if (file_exists(BASE_PATH . '/config/database.php')) {
  DB::init(Config::get('database'));
}
