<?php
declare(strict_types=1);
session_start();

header('Content-Type: image/png');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

if (!extension_loaded('gd')) {
  http_response_code(500);
  exit;
}

$a = random_int(1, 9);
$b = random_int(1, 9);
$op = random_int(0, 1) ? '+' : '-';
$ans = ($op === '+') ? ($a + $b) : ($a - $b);
$_SESSION['captcha_answer'] = (string)$ans;

$w = 180; $h = 60;
$img = imagecreatetruecolor($w, $h);
$bg = imagecolorallocate($img, 245, 245, 245);
$fg = imagecolorallocate($img, 40, 40, 40);
$noise = imagecolorallocate($img, 200, 200, 200);

imagefilledrectangle($img, 0, 0, $w, $h, $bg);

// noise
for ($i=0; $i<80; $i++) {
  imagesetpixel($img, random_int(0,$w-1), random_int(0,$h-1), $noise);
}
for ($i=0; $i<5; $i++) {
  imageline($img, random_int(0,$w-1), random_int(0,$h-1), random_int(0,$w-1), random_int(0,$h-1), $noise);
}

$text = "$a $op $b = ?";
$fontSize = 5;
imagestring($img, $fontSize, 40, 20, $text, $fg);

imagepng($img);
imagedestroy($img);
