<?php use App\Core\Helpers; ?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>تسجيل دخول الأدمن</title>
  <style>
    body{font-family:system-ui;margin:0;background:#fafafa}
    .wrap{max-width:420px;margin:60px auto;padding:16px}
    .card{background:#fff;border:1px solid #eee;border-radius:16px;padding:16px}
    input{width:100%;padding:10px;border:1px solid #ddd;border-radius:10px}
    label{display:block;margin:10px 0 6px}
    .btn{width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;background:#fff;cursor:pointer;margin-top:12px}
    .err{color:#b00020;font-size:13px;margin-top:10px}
    .muted{color:#666;font-size:14px}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <h2 style="margin-top:0">لوحة التحكم</h2>
      <p class="muted">سجّل دخولك كأدمن.</p>
      <?php if (!empty($error)): ?><div class="err"><?= Helpers::e($error) ?></div><?php endif; ?>
      <form method="post" action="/admin/login">
        <input type="hidden" name="_csrf" value="<?= Helpers::csrfToken() ?>" />
        <label>البريد</label>
        <input name="email" />
        <label>كلمة المرور</label>
        <input type="password" name="password" />
        <button class="btn" type="submit">دخول</button>
      </form>
      <div class="muted" style="margin-top:10px">لو لسه مركبتش المشروع: روح /install</div>
    </div>
  </div>
</body>
</html>
