<?php use App\Core\Helpers; use App\Core\Auth; ?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title><?= Helpers::e($title ?? 'لوحة التحكم') ?></title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto;margin:0;background:#fafafa;color:#111}
    .wrap{max-width:1200px;margin:0 auto;padding:16px}
    .top{display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap}
    a{color:#111}
    .btn{display:inline-block;padding:10px 14px;border-radius:10px;border:1px solid #ddd;background:#fff;cursor:pointer;text-decoration:none}
    .card{border:1px solid #eee;border-radius:14px;padding:14px;background:#fff}
    table{width:100%;border-collapse:collapse}
    th,td{padding:10px;border-bottom:1px solid #eee;text-align:right}
    input,textarea,select{width:100%;padding:10px;border:1px solid #ddd;border-radius:10px}
    .grid{display:grid;grid-template-columns:repeat(3,1fr);gap:12px}
    @media (max-width:900px){.grid{grid-template-columns:repeat(2,1fr)}}
    @media (max-width:600px){.grid{grid-template-columns:1fr}}
    .muted{color:#666;font-size:14px}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="top">
      <div>
        <strong>لوحة التحكم</strong>
        <span class="muted">— <?= Helpers::e(Auth::user()['name'] ?? '') ?></span>
      </div>
      <div style="display:flex;gap:8px;flex-wrap:wrap">
        <a class="btn" href="/admin/dashboard">Dashboard</a>
        <a class="btn" href="/admin/posts">المقالات</a>
        <a class="btn" href="/admin/works">الأعمال</a>
        <a class="btn" href="/admin/tickets">التذاكر</a>
        <form method="post" action="/admin/logout" style="display:inline">
          <input type="hidden" name="_csrf" value="<?= Helpers::csrfToken() ?>" />
          <button class="btn" type="submit">خروج</button>
        </form>
      </div>
    </div>
    <div style="margin-top:14px">
      <?= $content ?? '' ?>
    </div>
  </div>
</body>
</html>
