<?php use App\Core\Helpers; ?>
<?php $title="المقالات"; ob_start(); ?>
<div style="display:flex;justify-content:space-between;align-items:center;gap:10px;flex-wrap:wrap">
  <h2 style="margin:0">المقالات</h2>
  <a class="btn" href="/admin/posts/create">+ إضافة مقال</a>
</div>
<div class="card" style="margin-top:12px;overflow:auto">
  <table>
    <thead><tr><th>ID</th><th>العنوان</th><th>Slug</th><th>Views</th><th>تاريخ</th></tr></thead>
    <tbody>
    <?php foreach ($posts as $p): ?>
      <tr>
        <td><?= (int)$p['id'] ?></td>
        <td><a href="/admin/posts/<?= (int)$p['id'] ?>"><?= Helpers::e($p['title']) ?></a></td>
        <td><?= Helpers::e($p['slug']) ?></td>
        <td><?= (int)$p['views'] ?></td>
        <td class="muted"><?= Helpers::e(substr((string)$p['created_at'],0,10)) ?></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php $content=ob_get_clean(); require __DIR__ . '/../layout.php'; ?>
