<?php use App\Core\Helpers; ?>
<?php $title="التذاكر"; ob_start(); ?>
<h2 style="margin-top:0">تذاكر التواصل</h2>
<div class="card" style="overflow:auto">
<table>
  <thead><tr><th>ID</th><th>الاسم</th><th>القسم</th><th>العنوان</th><th>الحالة</th><th>تاريخ</th></tr></thead>
  <tbody>
  <?php foreach ($tickets as $t): ?>
    <tr>
      <td><?= (int)$t['id'] ?></td>
      <td><?= Helpers::e($t['name']) ?></td>
      <td><?= Helpers::e($t['department']) ?></td>
      <td><a href="/admin/tickets/<?= (int)$t['id'] ?>"><?= Helpers::e($t['subject']) ?></a></td>
      <td><?= Helpers::e($t['status']) ?></td>
      <td class="muted"><?= Helpers::e(substr((string)$t['created_at'],0,16)) ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php $content=ob_get_clean(); require __DIR__ . '/../layout.php'; ?>
