<?php use App\Core\Helpers; ?>
<?php $title="تفاصيل تذكرة"; ob_start(); ?>
<h2 style="margin-top:0">تذكرة #<?= (int)$ticket['id'] ?></h2>
<div class="card">
  <div><strong><?= Helpers::e($ticket['subject']) ?></strong></div>
  <div class="muted"><?= Helpers::e($ticket['department']) ?> • <?= Helpers::e($ticket['email']) ?> • <?= Helpers::e($ticket['whatsapp'] ?? '') ?></div>
  <hr style="border:none;border-top:1px solid #eee;margin:12px 0" />
  <div><?= nl2br(Helpers::e($ticket['message'])) ?></div>
  <?php if (!empty($ticket['attachment_path'])): ?>
    <div style="margin-top:10px"><a class="btn" href="/<?= Helpers::e($ticket['attachment_path']) ?>" target="_blank">تحميل المرفق</a></div>
  <?php endif; ?>
</div>

<h3 style="margin-top:14px">الردود</h3>
<?php foreach ($replies as $r): ?>
  <div class="card" style="margin-bottom:10px">
    <div class="muted"><?= Helpers::e(substr((string)$r['created_at'],0,16)) ?></div>
    <div><?= nl2br(Helpers::e($r['message'])) ?></div>
  </div>
<?php endforeach; ?>

<form class="card" method="post" action="/admin/tickets/<?= (int)$ticket['id'] ?>/reply">
  <input type="hidden" name="_csrf" value="<?= Helpers::csrfToken() ?>" />
  <label>رد جديد</label>
  <textarea rows="4" name="message"></textarea>
  <button class="btn" type="submit" style="margin-top:10px">إرسال الرد</button>
</form>

<?php $content=ob_get_clean(); require __DIR__ . '/../layout.php'; ?>
