<?php use App\Core\Helpers; ?>
<?php $title="إضافة عمل"; ob_start(); ?>
<h2 style="margin-top:0">إضافة عمل</h2>
<form class="card" method="post" action="/admin/works/store">
  <input type="hidden" name="_csrf" value="<?= Helpers::csrfToken() ?>" />

  <label>العنوان</label>
  <input name="title" value="<?= Helpers::e($old['title'] ?? '') ?>" />
  <?php if (!empty($errors['title'])): ?><div class="muted" style="color:#b00020"><?= Helpers::e($errors['title']) ?></div><?php endif; ?>

  <label>Slug</label>
  <input name="slug" value="<?= Helpers::e($old['slug'] ?? '') ?>" />
  <?php if (!empty($errors['slug'])): ?><div class="muted" style="color:#b00020"><?= Helpers::e($errors['slug']) ?></div><?php endif; ?>

  <label>التصنيف</label>
  <select name="category_slug">
    <option value="">اختر</option>
    <?php foreach ($cats as $c): ?>
      <option value="<?= Helpers::e($c['slug']) ?>"><?= Helpers::e($c['title']) ?></option>
    <?php endforeach; ?>
  </select>
  <?php if (!empty($errors['category_slug'])): ?><div class="muted" style="color:#b00020"><?= Helpers::e($errors['category_slug']) ?></div><?php endif; ?>

  <label>السنة</label>
  <input name="year" value="<?= Helpers::e($old['year'] ?? '') ?>" />

  <label>القطاع</label>
  <input name="sector" value="<?= Helpers::e($old['sector'] ?? '') ?>" />

  <label>الموقع</label>
  <input name="location" value="<?= Helpers::e($old['location'] ?? '') ?>" />

  <label>الوصف</label>
  <textarea rows="8" name="description"><?= Helpers::e($old['description'] ?? '') ?></textarea>

  <button class="btn" type="submit" style="margin-top:12px">حفظ</button>
</form>
<?php $content=ob_get_clean(); require __DIR__ . '/../layout.php'; ?>
