<?php use App\Core\Helpers; ?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title><?= Helpers::e($title ?? 'بوابة العملاء') ?></title>
  <style>
    body{font-family:system-ui;margin:0;background:#fff}
    .wrap{max-width:1200px;margin:0 auto;padding:16px}
    .btn{display:inline-block;padding:10px 14px;border-radius:10px;border:1px solid #ddd;background:#fff;cursor:pointer;text-decoration:none;color:#111}
    .card{border:1px solid #eee;border-radius:14px;padding:14px;background:#fff}
    .grid{display:grid;grid-template-columns:repeat(3,1fr);gap:12px}
    @media (max-width:900px){.grid{grid-template-columns:repeat(2,1fr)}}
    @media (max-width:600px){.grid{grid-template-columns:1fr}}
    .muted{color:#666;font-size:14px}
  </style>
</head>
<body>
<div class="wrap">
  <div style="display:flex;justify-content:space-between;align-items:center;gap:10px;flex-wrap:wrap">
    <strong>بوابة العملاء</strong>
    <div style="display:flex;gap:8px;flex-wrap:wrap">
      <a class="btn" href="/client/portal">الرئيسية</a>
      <a class="btn" href="/">الموقع</a>
      <form method="post" action="/client/logout" style="display:inline">
        <input type="hidden" name="_csrf" value="<?= Helpers::csrfToken() ?>" />
        <button class="btn" type="submit">خروج</button>
      </form>
    </div>
  </div>
  <div style="margin-top:14px">
    <?= $content ?? '' ?>
  </div>
</div>
</body>
</html>
