<?php use App\Core\Helpers; ?>
<?php $title = "اتصل بنا"; ob_start(); ?>
<h1 style="margin-top:0">اتصل بنا</h1>

<?php if (!empty($_SESSION['flash'])): ?>
  <div class="flash"><?= Helpers::e($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
<?php endif; ?>

<form class="card" method="post" action="/contact" enctype="multipart/form-data">
  <input type="hidden" name="_csrf" value="<?= Helpers::csrfToken() ?>" />
  <label>الاسم</label>
  <input name="name" value="<?= Helpers::e($old['name'] ?? '') ?>" />
  <?php if (!empty($errors['name'])): ?><div class="err"><?= Helpers::e($errors['name']) ?></div><?php endif; ?>

  <label>البريد الإلكتروني</label>
  <input name="email" value="<?= Helpers::e($old['email'] ?? '') ?>" />
  <?php if (!empty($errors['email'])): ?><div class="err"><?= Helpers::e($errors['email']) ?></div><?php endif; ?>

  <label>رقم واتساب</label>
  <input name="whatsapp" value="<?= Helpers::e($old['whatsapp'] ?? '') ?>" />

  <label>القسم</label>
  <select name="department">
    <option value="">اختر</option>
    <?php
      $deps = ['الدعم الفني','المبيعات','الوظائف','الشكاوي'];
      foreach ($deps as $d):
        $sel = (($old['department'] ?? '') === $d) ? 'selected' : '';
    ?>
      <option <?= $sel ?> value="<?= Helpers::e($d) ?>"><?= Helpers::e($d) ?></option>
    <?php endforeach; ?>
  </select>
  <?php if (!empty($errors['department'])): ?><div class="err"><?= Helpers::e($errors['department']) ?></div><?php endif; ?>

  <label>عنوان الرسالة</label>
  <input name="subject" value="<?= Helpers::e($old['subject'] ?? '') ?>" />
  <?php if (!empty($errors['subject'])): ?><div class="err"><?= Helpers::e($errors['subject']) ?></div><?php endif; ?>

  <label>التفاصيل</label>
  <textarea rows="6" name="message"><?= Helpers::e($old['message'] ?? '') ?></textarea>
  <?php if (!empty($errors['message'])): ?><div class="err"><?= Helpers::e($errors['message']) ?></div><?php endif; ?>

  <label>مرفق (اختياري)</label>
  <input type="file" name="attachment" />

  <label>اكتب ناتج العملية الظاهرة في الصورة</label>
  <div style="display:flex;gap:10px;align-items:center;flex-wrap:wrap">
    <img src="/captcha.php?<?= time() ?>" alt="captcha" style="border:1px solid #eee;border-radius:10px" />
    <input name="captcha" style="max-width:180px" />
  </div>
  <?php if (!empty($errors['captcha'])): ?><div class="err"><?= Helpers::e($errors['captcha']) ?></div><?php endif; ?>

  <button class="btn" type="submit" style="margin-top:12px">إرسال</button>
</form>

<?php $content = ob_get_clean(); require __DIR__ . '/../layout.php'; ?>
