<?php use App\Core\Helpers; ?>
<?php $title = "الرئيسية"; ob_start(); ?>

<h1 style="margin-top:0">شركة FirstM — نسخة برمجة خاصة</h1>
<p class="muted">ده قالب تشغيل جاهز. هتبدّل المحتوى والصور من لوحة التحكم.</p>

<h2>الخدمات</h2>
<div class="grid">
<?php foreach ($services as $s): ?>
  <div class="card">
    <strong><?= Helpers::e($s['title'] ?? '') ?></strong>
    <div class="muted"><?= Helpers::e($s['excerpt'] ?? '') ?></div>
  </div>
<?php endforeach; ?>
<?php if (!$services): ?>
  <div class="card muted">أضف خدمات من لوحة التحكم لاحقًا.</div>
<?php endif; ?>
</div>

<h2 style="margin-top:22px">سابقة الأعمال</h2>
<div class="grid">
<?php foreach ($works as $w): ?>
  <a class="card" href="/works/<?= Helpers::e($w['slug']) ?>" style="text-decoration:none;color:inherit">
    <strong><?= Helpers::e($w['title']) ?></strong>
    <div class="muted"><?= Helpers::e($w['year']) ?> • <?= Helpers::e($w['sector']) ?> • <?= Helpers::e($w['location']) ?></div>
  </a>
<?php endforeach; ?>
<?php if (!$works): ?>
  <div class="card muted">أضف أعمال من لوحة التحكم.</div>
<?php endif; ?>
</div>

<h2 style="margin-top:22px">آخر المقالات</h2>
<div class="grid">
<?php foreach ($posts as $p): ?>
  <a class="card" href="/blog/<?= Helpers::e($p['slug']) ?>" style="text-decoration:none;color:inherit">
    <strong><?= Helpers::e($p['title']) ?></strong>
    <div class="muted">مشاهدات: <?= (int)($p['views'] ?? 0) ?></div>
  </a>
<?php endforeach; ?>
<?php if (!$posts): ?>
  <div class="card muted">أضف مقالات من لوحة التحكم.</div>
<?php endif; ?>
</div>

<div style="margin-top:22px;display:flex;gap:10px;flex-wrap:wrap">
  <a class="btn" href="/admin">لوحة التحكم</a>
  <a class="btn" href="/client">بوابة العملاء</a>
</div>

<?php $content = ob_get_clean(); require __DIR__ . '/layout.php'; ?>
