<?php use App\Core\Helpers; ?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title><?= Helpers::e($title ?? 'FirstM Agency') ?></title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto; margin:0; background:#fff; color:#111}
    header{position:sticky;top:0;background:#fff;border-bottom:1px solid #eee;z-index:10}
    .wrap{max-width:1100px;margin:0 auto;padding:16px}
    nav a{margin-left:12px;text-decoration:none;color:#111}
    .btn{display:inline-block;padding:10px 14px;border-radius:10px;border:1px solid #ddd;background:#fff;cursor:pointer;text-decoration:none;color:#111}
    .card{border:1px solid #eee;border-radius:14px;padding:14px;background:#fff}
    .grid{display:grid;grid-template-columns:repeat(3,1fr);gap:12px}
    @media (max-width:900px){.grid{grid-template-columns:repeat(2,1fr)}}
    @media (max-width:600px){.grid{grid-template-columns:1fr}}
    footer{border-top:1px solid #eee;margin-top:28px}
    .muted{color:#666;font-size:14px}
    input,select,textarea{width:100%;padding:10px;border:1px solid #ddd;border-radius:10px}
    label{display:block;margin:10px 0 6px}
    .err{color:#b00020;font-size:13px}
    .flash{padding:12px;border-radius:12px;background:#f3fff3;border:1px solid #cceacc;margin:12px 0}
  </style>
</head>
<body>
<header>
  <div class="wrap">
    <div style="display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap">
      <div><strong>FIRSTM</strong> <span class="muted">Custom PHP</span></div>
      <nav>
        <a href="/">الرئيسية</a>
        <a href="/works">سابقة الأعمال</a>
        <a href="/blog">المقالات</a>
        <a href="/contact">اتصل بنا</a>
        <a class="btn" href="/client">منطقة العملاء</a>
      </nav>
    </div>
  </div>
</header>

<main class="wrap">
  <?= $content ?? '' ?>
</main>

<footer>
  <div class="wrap muted">© <?= date('Y') ?> FirstM Agency — Custom PHP+MySQL</div>
</footer>
</body>
</html>
