<?php
use App\Core\View;
use App\Controllers\HomeController;
use App\Controllers\BlogController;
use App\Controllers\WorksController;
use App\Controllers\ContactController;
use App\Controllers\Admin\AuthController as AdminAuth;
use App\Controllers\Admin\DashboardController;
use App\Controllers\Admin\PostsController;
use App\Controllers\Admin\WorksController as AdminWorks;
use App\Controllers\Admin\TicketsController;
use App\Controllers\Client\AuthController as ClientAuth;
use App\Controllers\Client\PortalController;

$router->get('/', [HomeController::class, 'index']);

$router->get('/blog', [BlogController::class, 'index']);
$router->get('/blog/{slug}', [BlogController::class, 'show']);

$router->get('/works', [WorksController::class, 'index']);
$router->get('/works/{slug}', [WorksController::class, 'show']);

$router->get('/contact', [ContactController::class, 'form']);
$router->post('/contact', [ContactController::class, 'submit']);

// Admin
$router->get('/admin', [AdminAuth::class, 'loginForm']);
$router->post('/admin/login', [AdminAuth::class, 'login']);
$router->post('/admin/logout', [AdminAuth::class, 'logout']);

$router->get('/admin/dashboard', [DashboardController::class, 'index']);
$router->get('/admin/posts', [PostsController::class, 'index']);
$router->get('/admin/posts/create', [PostsController::class, 'create']);
$router->post('/admin/posts/store', [PostsController::class, 'store']);
$router->get('/admin/posts/{id}', [PostsController::class, 'edit']);
$router->post('/admin/posts/{id}', [PostsController::class, 'update']);
$router->post('/admin/posts/{id}/delete', [PostsController::class, 'delete']);

$router->get('/admin/works', [AdminWorks::class, 'index']);
$router->get('/admin/works/create', [AdminWorks::class, 'create']);
$router->post('/admin/works/store', [AdminWorks::class, 'store']);

$router->get('/admin/tickets', [TicketsController::class, 'index']);
$router->get('/admin/tickets/{id}', [TicketsController::class, 'show']);
$router->post('/admin/tickets/{id}/reply', [TicketsController::class, 'reply']);

// Client portal
$router->get('/client', [ClientAuth::class, 'loginForm']);
$router->post('/client/login', [ClientAuth::class, 'login']);
$router->post('/client/logout', [ClientAuth::class, 'logout']);
$router->get('/client/portal', [PortalController::class, 'index']);
