<?php
declare(strict_types=1);

spl_autoload_register(function ($class) {
  $prefix = 'App\\';
  $baseDir = dirname(__DIR__) . '/app/';
  if (strncmp($prefix, $class, strlen($prefix)) !== 0) return;

  $relative = substr($class, strlen($prefix));
  $file = $baseDir . str_replace('\\', '/', $relative) . '.php';
  if (file_exists($file)) require $file;
});
